
# intro -------------------------------------------------------------
#Bioassay 'code names'
# Beetroot - Pythium                          # bee
# Onion - Phoma                               # oni1
# Onion - Fusarium                            # oni2
# Spinach - Pythium                           # spi1
# Spinach - Fusarium                          # spi2
# Coriander - Pythium                         # cor
# Pepper - Phytophthora capsici               # pep  / pepper
# Pepper - Phytophthora capsici SEEDS         # pep2 / pepperSeeds
# Perennial ryegrass - Laetisaria fuciformis  # per1
# Perennial ryegrass - Puccinia               # per2
# Red fescue - Laetisaria fuciformis          # fes

# import data -------------------------------------------------------------
#need to set working directory
#setwd()

germination_bee <- read.csv("Beetroot_4Rgermination.csv") 
germination_oni <- read.csv("Onion_4Rgermination.csv") 
germination_spi <- read.csv("Spinach_4Rgermination.csv") 
germination_cor <- read.csv("Coriander_4Rgermination.csv") 
germination_pep <- read.csv("Pepper_4Rgermination.csv") 

beetroot <- read.csv("Beetroot4R_data.csv")
onion <- read.csv("Onion4R_data.csv")
spinach <- read.csv("Spinach4R_data.csv")
coriander <- read.csv("Coriander4R_data.csv")
pepper <- read.csv("Pepper_plant_4Rdata.csv")
pepperSeeds <- read.csv('Pepper_seeds_4Rdata.csv')
perennial_puccinia <- read.csv("Perennial_puccinia_4Rdata.csv") 
perennial_thread <- read.csv('Perennial_thread_4Rdata.csv')
fescue_thread <- read.csv('Red_fescue_4Rdata.csv')


# packages ----------------------------------------------------------------
library(multcomp) #glm
library(MASS) #polr

library(ggplot2)
library(tidyverse)
library(ggpubr)
library(ggrepel)

library(plyr) #ddply for medians (pepper plants ordinal data)

# # GERMINATION # # -------------------------------------------------------------
#beetroot
germination <- germination_bee
germination$SeedLot <-as.character(germination$SeedLot)

germination$NoGer_energy <- 50-germination$Ger_energy 
germination$NoGer_capacity <- 50-germination$Ger_capacity
total <- unique(germination$SeedLot)
#energy
regression_list_energy <- list()
summary_list_energy <- list()
for(i in 1:length(total)){
  regression_list_energy[[i]] <- glm(cbind(Ger_energy, NoGer_energy)
                                     ~ MRTrt, 
                                     data=germination[germination$SeedLot==total[[i]],],
                                     family = "quasibinomial")
  names(regression_list_energy)[i] <- total[i]
  summary_list_energy[[i]]<-summary(regression_list_energy[[i]])
  names(summary_list_energy)[i] <- total[i]
}

#keep the info
regression_list_energy_be <-regression_list_energy 
summary_list_energy_be <- summary_list_energy

#capacity
regression_list_capacity <- list()
summary_list_capacity <- list()
for(i in 1:length(total)){
  regression_list_capacity[[i]] <- glm(cbind(Ger_capacity, NoGer_capacity)
                                       ~ MRTrt, 
                                       data=germination[germination$SeedLot==total[[i]],],
                                       family = "quasibinomial")
  names(regression_list_capacity)[i] <- total[i]
  summary_list_capacity[[i]]<-summary(regression_list_capacity[[i]])
  names(summary_list_capacity)[i] <- total[i]
}


#keep the info
regression_list_capacity_be <-regression_list_capacity
summary_list_capacity_be <- summary_list_capacity


#p values
pval_Ger_energy<-c()
pval_Ger_capacity<-c()
for(i in 1:length(total)){
  pval_Ger_energy[i]<-summary_list_energy[[i]]$coefficients[2,4]
  pval_Ger_capacity[i]<-summary_list_capacity[[i]]$coefficients[2,4]
  names(pval_Ger_energy)[i] <- total[i]
  names(pval_Ger_capacity)[i] <- total[i]
  
}
SeedLot <- total

pval_ger_bee <- data.frame(SeedLot,pval_Ger_energy=c(round(pval_Ger_energy,digits=6)),
           pval_Ger_capacity=c(round(pval_Ger_capacity,digits=6)))


#onion
germination <- germination_oni
germination$NoGer_energy <- 50-germination$Ger_energy 
germination$NoGer_capacity <- 50-germination$Ger_capacity
total <- unique(germination$SeedLot)
#energy
regression_list_energy <- list()
summary_list_energy <- list()
for(i in 1:length(total)){
  regression_list_energy[[i]] <- glm(cbind(Ger_energy, NoGer_energy)
                                     ~ MRTrt, 
                                     data=germination[germination$SeedLot==total[[i]],],
                                     family = "quasibinomial")
  names(regression_list_energy)[i] <- total[i]
  summary_list_energy[[i]]<-summary(regression_list_energy[[i]])
  names(summary_list_energy)[i] <- total[i]
}


#keep the info
regression_list_energy_on <-regression_list_energy
summary_list_energy_on <- summary_list_energy

#capacity
regression_list_capacity <- list()
summary_list_capacity <- list()
for(i in 1:length(total)){
  regression_list_capacity[[i]] <- glm(cbind(Ger_capacity, NoGer_capacity)
                                       ~ MRTrt, 
                                       data=germination[germination$SeedLot==total[[i]],],
                                       family = "quasibinomial")
  names(regression_list_capacity)[i] <- total[i]
  summary_list_capacity[[i]]<-summary(regression_list_capacity[[i]])
  names(summary_list_capacity)[i] <- total[i]
}


#keep the info
regression_list_capacity_on <-regression_list_capacity
summary_list_capacity_on <- summary_list_capacity

#p values
pval_Ger_energy<-c()
pval_Ger_capacity<-c()
for(i in 1:length(total)){
  pval_Ger_energy[i]<-summary_list_energy[[i]]$coefficients[2,4]
  pval_Ger_capacity[i]<-summary_list_capacity[[i]]$coefficients[2,4]
  names(pval_Ger_energy)[i] <- total[i]
  names(pval_Ger_capacity)[i] <- total[i]
  
}
SeedLot <- total
pval_ger_oni <- data.frame(SeedLot,pval_Ger_energy=c(round(pval_Ger_energy,digits=6)),
                           pval_Ger_capacity=c(round(pval_Ger_capacity,digits=6)))


#spinach
germination <- germination_spi
germination$NoGer_energy <- 50-germination$Ger_energy 
germination$NoGer_capacity <- 50-germination$Ger_capacity
total <- unique(germination$SeedLot)
#energy
regression_list_energy <- list()
summary_list_energy <- list()
for(i in 1:length(total)){
  regression_list_energy[[i]] <- glm(cbind(Ger_energy, NoGer_energy)
                                     ~ MRTrt, 
                                     data=germination[germination$SeedLot==total[[i]],],
                                     family = "quasibinomial")
  names(regression_list_energy)[i] <- total[i]
  summary_list_energy[[i]]<-summary(regression_list_energy[[i]])
  names(summary_list_energy)[i] <- total[i]
}

#keep the info
regression_list_energy_sp <-regression_list_energy
summary_list_energy_sp <- summary_list_energy

#capacity
regression_list_capacity <- list()
summary_list_capacity <- list()
for(i in 1:length(total)){
  regression_list_capacity[[i]] <- glm(cbind(Ger_capacity, NoGer_capacity)
                                       ~ MRTrt, 
                                       data=germination[germination$SeedLot==total[[i]],],
                                       family = "quasibinomial")
  names(regression_list_capacity)[i] <- total[i]
  summary_list_capacity[[i]]<-summary(regression_list_capacity[[i]])
  names(summary_list_capacity)[i] <- total[i]
}
#keep the info
regression_list_capacity_sp <-regression_list_capacity
summary_list_capacity_sp <- summary_list_capacity

#p values
pval_Ger_energy<-c()
pval_Ger_capacity<-c()
for(i in 1:length(total)){
  pval_Ger_energy[i]<-summary_list_energy[[i]]$coefficients[2,4]
  pval_Ger_capacity[i]<-summary_list_capacity[[i]]$coefficients[2,4]
  names(pval_Ger_energy)[i] <- total[i]
  names(pval_Ger_capacity)[i] <- total[i]
  
}
SeedLot <- total
pval_ger_spi <- data.frame(SeedLot,pval_Ger_energy=c(round(pval_Ger_energy,digits=6)),
                           pval_Ger_capacity=c(round(pval_Ger_capacity,digits=6)))



#coriander
germination <- germination_cor
germination$NoGer_capacity <- 100-germination$Ger_capacity
total <- unique(germination$SeedLot)
#energy - NA

#capacity
regression_list_capacity <- list()
summary_list_capacity <- list()
for(i in 1:length(total)){
  regression_list_capacity[[i]] <- glm(cbind(Ger_capacity, NoGer_capacity)
                                       ~ MRTrt, 
                                       data=germination[germination$SeedLot==total[[i]],],
                                       family = "quasibinomial")
  names(regression_list_capacity)[i] <- total[i]
  summary_list_capacity[[i]]<-summary(regression_list_capacity[[i]])
  names(summary_list_capacity)[i] <- total[i]
}

#keep the info
regression_list_capacity_co <-regression_list_capacity
summary_list_capacity_co <- summary_list_capacity

#p values
pval_Ger_energy<-c()
pval_Ger_capacity<-c()
for(i in 1:length(total)){
  pval_Ger_energy[i]<-summary_list_energy[[i]]$coefficients[2,4]
  pval_Ger_capacity[i]<-summary_list_capacity[[i]]$coefficients[2,4]
  names(pval_Ger_energy)[i] <- total[i]
  names(pval_Ger_capacity)[i] <- total[i]
  
}
SeedLot <- total
pval_ger_cor <- data.frame(SeedLot,pval_Ger_energy='NA', pval_Ger_capacity=c(round(pval_Ger_capacity,digits=6)))

#pepper
data <- germination_pep
total <- unique(data$SeedLot)
SeedLot <- total

difference_Germination <- c()
for(i in 1:length(unique(data$SeedLot))){
  difference_Germination[i] <- ((mean(data[data$MRTrt=='untrt' & 
                                             data$SeedLot==unique(data$SeedLot)[i],]$Germination)) -
                                  (mean(data[data$MRTrt=='trt'   & 
                                               data$SeedLot==unique(data$SeedLot)[i],]$Germination)))
}

pval_Ger_capacity <-c()
pval_Ger_capacity [(difference_Germination <= -3)|
                     (difference_Germination >= 3)]   <- "0"
pval_Ger_capacity [(difference_Germination > -3)&
                     (difference_Germination < 3)]   <- "1"
pval_ger_pep <- data.frame(SeedLot,pval_Ger_energy='NA', pval_Ger_capacity)

#perennial ryegrass
perennial_puccinia$No_germination<- 100-perennial_puccinia$Germination
perennial_puccinia$Replicate <-as.character(perennial_puccinia$Replicate)
perennial_puccinia$SeedLot <-as.character(perennial_puccinia$SeedLot)
total_perennial <- unique(perennial_puccinia$SeedLot)
#capacity
regression_list_per_ger <- list()
summary_list_per_ger <- list()
for(i in 1:length(total_perennial)){
  regression_list_per_ger[[i]] <- glm(cbind(Germination, No_germination)
                                      ~ MRTrt, data=perennial_puccinia[perennial_puccinia$SeedLot==total_perennial[[i]],],
                                      family = "quasibinomial")
  names(regression_list_per_ger)[i] <- total_perennial[i]
  summary_list_per_ger[[i]]<-summary(regression_list_per_ger[[i]])
  names(summary_list_per_ger)[i] <- total_perennial[i]
}

#p values
##for perennial and fescue I look at coefficients[4,4]
pval_Ger_perennial<-c()
for(i in 1:length(total_perennial)){
  pval_Ger_perennial[i]<-summary_list_per_ger[[i]]$coefficients[2,4]
  names(pval_Ger_perennial)[i] <- total_perennial[i]
  
}
SeedLot <- total_perennial
pval_ger_per <- data.frame(SeedLot,pval_Ger_energy='NA', pval_Ger_capacity=c(round(pval_Ger_perennial,digits=6)))

#red fescue
fescue_thread$No_germination<- 100-fescue_thread$Germination
fescue_thread$Replicate <-as.character(fescue_thread$Replicate)
fescue_thread$SeedLot <-as.character(fescue_thread$SeedLot)
total_fescue <- unique(fescue_thread$SeedLot)

#capacity
regression_list_fes_ger <- list()
summary_list_fes_ger <- list()
for(i in 1:length(total_fescue)){
  regression_list_fes_ger[[i]] <- glm(cbind(Germination, No_germination)
                                      ~ MRTrt, 
                                      data=fescue_thread[fescue_thread$SeedLot==total_fescue[[i]],],
                                      family = "quasibinomial")
  names(regression_list_fes_ger)[i] <- total_fescue[i]
  summary_list_fes_ger[[i]]<-summary(regression_list_fes_ger[[i]])
  names(summary_list_fes_ger)[i] <- total_fescue[i]
}

#p values
pval_Ger_fescue<-c()
for(i in 1:length(total_fescue)){
  pval_Ger_fescue[i]<-summary_list_fes_ger[[i]]$coefficients[2,4]
  names(pval_Ger_fescue)[i] <- total_fescue[i]
  
}
SeedLot <- total_fescue
pval_ger_fes <- data.frame(SeedLot,pval_Ger_energy='NA', pval_Ger_capacity=c(round(pval_Ger_fescue,digits=6)))

pval_ger_bee1 <- cbind(pval_ger_bee, BioassayType='Beetroot_Pythium', crop='Beetroot')
pval_ger_oni1 <- cbind(pval_ger_oni, BioassayType='Onion_Phoma', crop='Onion')
pval_ger_oni2 <- cbind(pval_ger_oni, BioassayType='Onion_Fusarium', crop='Onion')
pval_ger_spi1 <- cbind(pval_ger_spi, BioassayType='Spinach_Pythium', crop='Spinach')
pval_ger_spi2 <- cbind(pval_ger_spi, BioassayType='Spinach_Fusarium', crop='Spinach')
pval_ger_cor1 <- cbind(pval_ger_cor, BioassayType='Coriander_Pythium', crop='Coriander')
pval_ger_pep1 <- cbind(pval_ger_pep, BioassayType='Pepper plants_Phytophthora capsici', crop='Pepper')
pval_ger_pep2 <- cbind(pval_ger_pep, BioassayType='Pepper seeds_Phytophthora capsici', crop='Pepper')
pval_ger_per1 <- cbind(pval_ger_per, BioassayType='Perennial ryegrass_Laetisaria fuciformis', crop='Perennial ryegrass')
pval_ger_per2 <- cbind(pval_ger_per, BioassayType='Perennial ryegrass_Puccinia sp.', crop='Perennial ryegrass')
pval_ger_fes1 <- cbind(pval_ger_fes, BioassayType='Red fescue_Laetisaria fuciformis', crop='Red fescue')

summary(pval_ger_bee)

# # make full_summary table -------------------------------------------------------------
full_summary <- rbind(pval_ger_bee1, pval_ger_oni1, pval_ger_oni2, pval_ger_spi1, pval_ger_spi2,
                            pval_ger_cor1, pval_ger_pep1, pval_ger_pep2, pval_ger_per1, pval_ger_per2, pval_ger_fes1)

head(full_summary)

#record for which seed lots both germination energy and capacity remained unaffected
full_summary$Ger_energy[full_summary$pval_Ger_energy < 0.05] <- "affected"
full_summary$Ger_energy[(full_summary$pval_Ger_energy >= 0.05) & 
                (full_summary$pval_Ger_energy != "affected" )] <- "unaffected"

full_summary$Ger_capacity[full_summary$pval_Ger_capacity < 0.05] <- "affected"
full_summary$Ger_capacity[(full_summary$pval_Ger_capacity >= 0.05) & 
                (full_summary$pval_Ger_capacity != "affected" )] <- "unaffected"

head(full_summary)




# # BIOASSAYS # #   -------------------------------------------------------------
# Beetroot - Pythium-------------------------------------------------------------
# 
beetroot$inf_count_pre <- as.numeric(beetroot$Inf_pre/100*20)
beetroot$inf_count_post <- as.numeric(beetroot$Inf_post/100*20)
beetroot$uninf_count_pre <- 20-beetroot$inf_count_pre 
beetroot$uninf_count_post <- 20-beetroot$inf_count_post
total <- unique(beetroot$SeedLot)

#predamping off
regression_list_pre <- list()
summary_list_pre <- list()
for(i in 1:length(total)){
  regression_list_pre[[i]] <- glm(cbind(inf_count_pre, uninf_count_pre)
                                  ~ Block + MRTrt, data=beetroot[beetroot$SeedLot==total[[i]],],
                                  family = "quasibinomial")
  names(regression_list_pre)[i] <- total[i]
  summary_list_pre[[i]]<-summary(regression_list_pre[[i]])
  names(summary_list_pre)[i] <- total[i]
}


#for postdamping off
regression_list_post <- list()
summary_list_post <- list()
for(i in 1:length(total)){
  regression_list_post[[i]] <- glm(cbind(inf_count_post, uninf_count_post)
                                   ~ Block + MRTrt, data=beetroot[beetroot$SeedLot==total[[i]],],
                                   family = "quasibinomial")
  names(regression_list_post)[i] <- total[i]
  summary_list_post[[i]]<-summary(regression_list_post[[i]])
  names(summary_list_post)[i] <- total[i]
}

#keep the info
regression_list_post_be <- regression_list_post

pval_pre<-c()
pval_post<-c()
for(i in 1:length(total)){
  pval_pre[i]<-summary_list_pre[[i]]$coefficients[5,4]
  pval_post[i]<-summary_list_post[[i]]$coefficients[5,4]
  names(pval_pre)[i] <- total[i]
  names(pval_post)[i] <- total[i]
  
}
SeedLot <- total
pval_bio_bee <- data.frame(SeedLot,P_value_bio1=c(round(pval_pre,digits=6)),
           P_value_bio2=c(round(pval_post,digits=6)))

# Onion - Phoma (two replicates; data not statistically analysed) -------------------------------------------------------------
total <- unique(onion$SeedLot)
SeedLot <- total
pval_bio_oni1 <- data.frame(SeedLot,P_value_bio1='NA', P_value_bio2='NA')


# Onion - Fusarium data prep-------------------------------------------------------------
onion$inf_count_post_13 <- as.numeric(onion$Inf_post_13/100*20)
onion$inf_count_pre_13 <- as.numeric(onion$Inf_pre_13/100*20)
onion$uninf_count_post_13 <- 20-onion$inf_count_post_13 
onion$uninf_count_pre_13 <- 20-onion$inf_count_pre_13 
#manual adjustment necessary in the cases that more than 20 seeds were sown
#seed lot 115 
onion$inf_count_post_13[which (onion$SeedLot %in% c(115) &onion$Block %in% c('B')&onion$MRTrt %in% c('untrt'))] <- 12
onion$inf_count_pre_13[which (onion$SeedLot %in% c(115) &onion$Block %in% c('B')&onion$MRTrt %in% c('untrt'))] <- 0
#seed lot 117 
onion$inf_count_post_13[which(onion$SeedLot %in% c(117)&onion$Block %in% c('C')&onion$MRTrt %in% c('trt'))] <- 9
onion$inf_count_pre_13[which(onion$SeedLot %in% c(117)&onion$Block %in% c('C')&onion$MRTrt %in% c('trt'))] <- 0
#seed lot 118 
onion$inf_count_post_13[which(onion$SeedLot %in% c(118)&onion$Block %in% c('B')&onion$MRTrt %in% c('trt'))] <- 9
onion$inf_count_pre_13[which(onion$SeedLot %in% c(118)&onion$Block %in% c('B')&onion$MRTrt %in% c('trt'))] <- 0
#seed lot 127 
onion$inf_count_post_13[which(onion$SeedLot %in% c(127)&onion$Block %in% c('D')&onion$MRTrt %in% c('trt'))] <- 8
onion$inf_count_pre_13[which(onion$SeedLot %in% c(127)&onion$Block %in% c('D')&onion$MRTrt %in% c('trt'))] <- 0
#seed lot 128 
onion$inf_count_post_13[which(onion$SeedLot %in% c(128)&onion$Block %in% c('D')&onion$MRTrt %in% c('trt'))] <- 8
onion$inf_count_pre_13[which(onion$SeedLot %in% c(128)&onion$Block %in% c('D')&onion$MRTrt %in% c('trt'))] <- 0
#calculate the number of plants which remained uninfected (or hadn't emerged)
#seed lot 115 
onion$uninf_count_post_13[which(onion$SeedLot %in% c(115)&onion$Block %in% c('B')&onion$MRTrt %in% c('untrt'))] <- 22-12
onion$uninf_count_pre_13[which(onion$SeedLot %in% c(115)&onion$Block %in% c('B')&onion$MRTrt %in% c('untrt'))] <- 22-0
#seed lot 117 
onion$uninf_count_post_13[which(onion$SeedLot %in% c(117)&onion$Block %in% c('C')&onion$MRTrt %in% c('trt'))] <- 21-9
onion$uninf_count_pre_13[which(onion$SeedLot %in% c(117)&onion$Block %in% c('C')&onion$MRTrt %in% c('trt'))] <- 21-0
#seed lot 118 
onion$uninf_count_post_13[which(onion$SeedLot %in% c(118)&onion$Block %in% c('B')&onion$MRTrt %in% c('trt'))] <- 21-9
onion$uninf_count_pre_13[which(onion$SeedLot %in% c(118)&onion$Block %in% c('B')&onion$MRTrt %in% c('trt'))] <- 21-0
#seed lot 127 
onion$uninf_count_post_13[which(onion$SeedLot %in% c(127)&onion$Block %in% c('D')&onion$MRTrt %in% c('trt'))] <- 21-8
onion$uninf_count_pre_13[which(onion$SeedLot %in% c(127)&onion$Block %in% c('D')&onion$MRTrt %in% c('trt'))] <- 21-0
#seed lot 128 
onion$uninf_count_post_13[which(onion$SeedLot %in% c(128)&onion$Block %in% c('D')&onion$MRTrt %in% c('trt'))] <- 21-8
onion$uninf_count_pre_13[which(onion$SeedLot %in% c(128)&onion$Block %in% c('D')&onion$MRTrt %in% c('trt'))] <- 21-0
# Onion - Fusarium -------------------------------------------------------------
total <- unique(onion$SeedLot)
#pre-damping off
regression_list_pre_13 <- list()
summary_list_pre_13 <- list()
for(i in 1:length(total)){
  regression_list_pre_13[[i]] <- glm(cbind(inf_count_pre_13, uninf_count_pre_13)
                                     ~ Block + MRTrt, data=onion[onion$SeedLot==total[[i]],],
                                     family = "quasibinomial")
  names(regression_list_pre_13)[i] <- total[i]
  summary_list_pre_13[[i]]<-summary(regression_list_pre_13[[i]])
  names(summary_list_pre_13)[i] <- total[i]
}

#post-damping off
regression_list_post_13 <- list()
summary_list_post_13 <- list()
for(i in 1:length(total)){
  regression_list_post_13[[i]] <- glm(cbind(inf_count_post_13, uninf_count_post_13)
                                      ~ Block + MRTrt, data=onion[onion$SeedLot==total[[i]],],
                                      family = "quasibinomial")
  names(regression_list_post_13)[i] <- total[i]
  summary_list_post_13[[i]]<-summary(regression_list_post_13[[i]])
  names(summary_list_post_13)[i] <- total[i]
}

pval_Inf_pre_13<-c()
pval_Inf_post_13<-c()

for(i in 1:length(total)){
  pval_Inf_pre_13[i]<-summary_list_pre_13[[i]]$coefficients[5,4]
  pval_Inf_post_13[i]<-summary_list_post_13[[i]]$coefficients[5,4]
  names(pval_Inf_pre_13)[i] <- total[i]
  names(pval_Inf_post_13)[i] <- total[i]
}

SeedLot <- total
pval_bio_oni2 <- data.frame(SeedLot,P_value_bio1=c(round(pval_Inf_pre_13,digits=6)),
                           P_value_bio2=c(round(pval_Inf_post_13,digits=6)))


# Spinach - Pythium-------------------------------------------------------------
# 
# (note: replicates were not paired and thus not considered a covariate of the model)
spinach$nonEmerge_count_fin <- as.numeric(63-spinach$Emerge_count_fin)
total <- unique(spinach$SeedLot)
#for emergence at the end of the experiment
regression_list_Emerge_fin <- list()
summary_list_Emerge_fin <- list()
for(i in 1:length(total)){
  regression_list_Emerge_fin[[i]] <- glm(cbind(nonEmerge_count_fin, Emerge_count_fin)
                                         ~ MRTrt, data=spinach[spinach$SeedLot==total[[i]],],
                                         family = "quasibinomial")
  names(regression_list_Emerge_fin)[i] <- total[i]
  summary_list_Emerge_fin[[i]]<-summary(regression_list_Emerge_fin[[i]])
  names(summary_list_Emerge_fin)[i] <- total[i]
}
#for post-damping off infection (%) at the end of the experiment
regression_list_post <- list()
summary_list_post <- list()
for(i in 1:length(total)){
  regression_list_post[[i]] <- glm(cbind(Uninf_count_post, Inf_count_post)
                                   ~ MRTrt, data=spinach[spinach$SeedLot==total[[i]],],
                                   family = "quasibinomial")
  names(regression_list_post)[i] <- total[i]
  summary_list_post[[i]]<-summary(regression_list_post[[i]])
  names(summary_list_post)[i] <- total[i]
}
#p values
pval_Emerge_fin <-c()
pval_post <-c()

for(i in 1:length(total)){
  pval_Emerge_fin[i]<-summary_list_Emerge_fin[[i]]$coefficients[2,4]
  pval_post[i]<-summary_list_post[[i]]$coefficients[2,4]
  names(pval_Emerge_fin)[i] <- total[i]
  names(pval_post)[i] <- total[i]
}

SeedLot <- total
pval_bio_spi1 <- data.frame(SeedLot,P_value_bio1=c(round(pval_Emerge_fin,digits=6)),
                           P_value_bio2=c(round(pval_post,digits=6)))

# Spinach - Fusarium (two replicates; data not statistically analysed)-------------------------------------------------------------
# 
total <- unique(spinach$SeedLot)
SeedLot <- total
pval_bio_spi2 <- data.frame(SeedLot,P_value_bio1='NA', P_value_bio2='NA')
# Coriander - Pythium (note: replicates were not paired and thus not considered a covariate of the model)-------------------------------------------------------------
coriander$non_total_emerge2 <- 100-coriander$total_emerge2 
coriander$uninf_post2 <- 100-coriander$Inf_post2
total <- unique(coriander$SeedLot)
#for emergence
regression_list_total_emerge2 <- list()
summary_list_total_emerge2 <- list()
for(i in 1:length(total)){
  regression_list_total_emerge2[[i]] <- glm(cbind(total_emerge2, non_total_emerge2)
                                            ~ MRTrt, data=coriander[coriander$SeedLot==total[[i]],],
                                            family = "quasibinomial")
  names(regression_list_total_emerge2)[i] <- total[i]
  summary_list_total_emerge2[[i]]<-summary(regression_list_total_emerge2[[i]])
  names(summary_list_total_emerge2)[i] <- total[i]
}

#for post-damping off
regression_list_post2 <- list()
summary_list_post2 <- list()
for(i in 1:length(total)){
  regression_list_post2[[i]] <- glm(cbind(Inf_post2, uninf_post2)
                                    ~ MRTrt, data=coriander[coriander$SeedLot==total[[i]],],
                                    family = "quasibinomial")
  names(regression_list_post2)[i] <- total[i]
  summary_list_post2[[i]]<-summary(regression_list_post2[[i]])
  names(summary_list_post2)[i] <- total[i]
}

pval_total_emerge2<-c()
pval_post2<-c()
for(i in 1:length(total)){
  pval_total_emerge2[i]<-summary_list_total_emerge2[[i]]$coefficients[2,4]
  pval_post2[i]<-summary_list_post2[[i]]$coefficients[2,4]
  names(pval_total_emerge2)[i] <- total[i]
  names(pval_post2)[i] <- total[i]
  
}
SeedLot <- total
pval_bio_cor <- data.frame(SeedLot,P_value_bio1=c(round(pval_total_emerge2,digits=6)),
                           P_value_bio2=c(round(pval_post2,digits=6)))

# Pepper - Phytophthora capsici PLANTS ordinal (note: replicates were not paired and thus not considered a covariate of the model) -------------------------------------------------------------
total <- unique(pepper$SeedLot)
pepper$MRTrt <-as.factor(pepper$MRTrt)

pepper$Evaluation1 <-as.numeric(pepper$Evaluation1)
pepper$Evaluation2 <-as.numeric(pepper$Evaluation2)
pepperMed <- ddply(pepper, c('MRTrt', 'SeedLot', 'Replicate'), summarise,
                   median.Evaluation1 = median(Evaluation1),
                   median.Evaluation2 = median(Evaluation2))

pepperMed$median.Evaluation1 <-as.factor(pepperMed$median.Evaluation1)
pepperMed$median.Evaluation2 <-as.factor(pepperMed$median.Evaluation2)

#evaluation 1
regression_list_median.Evaluation1 <- list() #store ordinal regressions
summary_list_median.Evaluation1 <- list() #store full summaries
table_list_median.Evaluation1 <- list() #store coefficient tables
pvalues_list_median.Evaluation1 <- list() #calculate and store pvalues

for(i in 1:length(total)){
  #ordinal regressions
  regression_list_median.Evaluation1[[i]] <- polr(formula= median.Evaluation1 ~ MRTrt, 
                                                  data = pepperMed[pepperMed$SeedLot==total[[i]],])
  names(regression_list_median.Evaluation1)[i] <- total[i]
  #store full summaries
  summary_list_median.Evaluation1[[i]]<-summary(regression_list_median.Evaluation1[[i]])
  names(summary_list_median.Evaluation1)[i] <- total[i]
  #get the coefficients of each model
  table_list_median.Evaluation1[[i]] <- coef(summary(regression_list_median.Evaluation1[[i]]))
  #calculate and store pvalues
  pvalues_list_median.Evaluation1[[i]] <- pnorm(abs(table_list_median.Evaluation1[[i]][, "t value"]), 
                                                lower.tail = FALSE) * 2 # two-tailed t-test
  #add pvalues on table
  table_list_median.Evaluation1[[i]] <- cbind(table_list_median.Evaluation1[[i]], "p value" = pvalues_list_median.Evaluation1[[i]])
}

#evaluation 2
regression_list_median.Evaluation2 <- list() #store ordinal regressions
summary_list_median.Evaluation2 <- list() #store full summaries
table_list_median.Evaluation2 <- list() #store coefficient tables
pvalues_list_median.Evaluation2 <- list() #calculate and store pvalues


for(i in 1:length(total)){
  #ordinal regressions
  regression_list_median.Evaluation2[[i]] <- polr(formula= median.Evaluation2 ~ MRTrt, 
                                                  data = pepperMed[pepperMed$SeedLot==total[[i]],])
  names(regression_list_median.Evaluation2)[i] <- total[i]
  #store full summaries
  summary_list_median.Evaluation2[[i]]<-summary(regression_list_median.Evaluation2[[i]])
  names(summary_list_median.Evaluation2)[i] <- total[i]
  #get the coefficients of each model
  table_list_median.Evaluation2[[i]] <- coef(summary(regression_list_median.Evaluation2[[i]]))
  #calculate and store pvalues
  pvalues_list_median.Evaluation2[[i]] <- pnorm(abs(table_list_median.Evaluation2[[i]][, "t value"]), 
                                                lower.tail = FALSE) * 2 # two-tailed t-test
  #add pvalues on table
  table_list_median.Evaluation2[[i]] <- cbind(table_list_median.Evaluation2[[i]], "p value" = pvalues_list_median.Evaluation2[[i]])
}


pval_median.Evaluation1<-c()
pval_median.Evaluation2<-c()
for(i in 1:length(total)){
  pval_median.Evaluation1[i]<-table_list_median.Evaluation1[[i]][1,4]
  pval_median.Evaluation2[i]<-table_list_median.Evaluation2[[i]][1,4]
  names(pval_median.Evaluation1)[i] <- total[i]
  names(pval_median.Evaluation2)[i] <- total[i]
  
}

SeedLot <- total
pval_bio_pep <- data.frame(SeedLot,P_value_bio1=c(round(pval_median.Evaluation1,digits=6)),
                           P_value_bio2=c(round(pval_median.Evaluation2,digits=6)))

# Pepper - Phytophthora capsici SEEDS continuous (note: replicates were not paired and thus not considered a covariate of the model)-------------------------------------------------------------
# 
#prep data
pep2 <- pepperSeeds

pep2$Missing <- as.numeric(pep2$Ev3_missing)
pep2$Dead <- as.numeric(pep2$Ev3_dead)
pep2$Not_Missing <- 8-pep2$Missing 
pep2$Not_Dead <- 8-pep2$Dead
total <- unique(pep2$SeedLot)

#regression
#missing plants
regression_list_missing <- list()
summary_list_missing <- list()
for(i in 1:length(total)){
  regression_list_missing[[i]] <- glm(cbind(Missing, Not_Missing)
                                      ~ MRTrt, data=pep2[pep2$SeedLot==total[[i]],],
                                      family = "quasibinomial")
  names(regression_list_missing)[i] <- total[i]
  summary_list_missing[[i]]<-summary(regression_list_missing[[i]])
  names(summary_list_missing)[i] <- total[i]
}
#dead plants
regression_list_dead <- list()
summary_list_dead <- list()
for(i in 1:length(total)){
  regression_list_dead[[i]] <- glm(cbind(Dead, Not_Dead)
                                   ~ MRTrt, data=pep2[pep2$SeedLot==total[[i]],],
                                   family = "quasibinomial")
  names(regression_list_dead)[i] <- total[i]
  summary_list_dead[[i]]<-summary(regression_list_dead[[i]])
  names(summary_list_dead)[i] <- total[i]
}

#p-values
pval_miss<-c()
pval_dead<-c()
for(i in 1:length(total)){
  pval_miss[i]<-summary_list_missing[[i]]$coefficients[2,4]
  pval_dead[i]<-summary_list_dead[[i]]$coefficients[2,4]
  names(pval_miss)[i] <- total[i]
  names(pval_dead)[i] <- total[i]
  
}
SeedLot <- total
pval_bio_pep2 <- data.frame(SeedLot,P_value_bio1=c(round(pval_miss,digits=6)),
                            P_value_bio2=c(round(pval_dead,digits=6)))

## Grasses (note: replicates were randomised, not paired and thus not Replicate is considered a covariate of the model)---------------------------------------------

# Red fescue - Laetisaria fuciformis-------------------------------------------------------------
fescue_thread$Disease.group <- 0
fescue_thread$Disease.group[which(fescue_thread$Disease=='1' | fescue_thread$Disease=='2')] <- 1

fescue_thread$Disease <-as.factor(fescue_thread$Disease)
fescue_thread$MRTrt <-as.factor(fescue_thread$MRTrt)
total_fescue <- unique(fescue_thread$SeedLot)

regression_list_fes_thr <- list()
summary_list_fes_thr <- list()
for(i in 1:length(total_fescue)){
  regression_list_fes_thr[[i]] <- glm(Disease ~ MRTrt, 
                                      data = fescue_thread[fescue_thread$SeedLot==total_fescue[[i]],], 
                                      family = "binomial"(link='logit'))
  names(regression_list_fes_thr)[i] <- total_fescue[i]
  summary_list_fes_thr[[i]]<-summary(regression_list_fes_thr[[i]])
  names(summary_list_fes_thr)[i] <- total_fescue[i]
}

pval_fes_thr<-c()
for(i in 1:length(total_fescue)){
  pval_fes_thr[i]<-summary_list_fes_thr[[i]]$coefficients[2,4]
  names(pval_fes_thr)[i] <- total_fescue[i]
}

SeedLot <- total_fescue
pval_bio_fes <- data.frame(SeedLot,P_value_bio1=c(round(pval_fes_thr,digits=6)),
                          P_value_bio2='NA')

# Perennial ryegrass - Laetisaria fuciformis-------------------------------------------------------------
perennial_thread$Disease.group <- 0
perennial_thread$Disease.group[which(perennial_thread$Disease=='1' | perennial_thread$Disease=='2')] <- 1

perennial_thread$Disease <-as.factor(perennial_thread$Disease)
perennial_thread$MRTrt <-as.factor(perennial_thread$MRTrt)
total_perennial <- unique(perennial_thread$SeedLot)

regression_list_per_thr <- list() #store ordinal regressions
summary_list_per_thr <- list() #store full summaries
for(i in 1:length(total_perennial)){
  regression_list_per_thr[[i]] <- glm(Disease ~ MRTrt, 
                                      data = perennial_thread[perennial_thread$SeedLot==total_perennial[[i]],], 
                                      family = "binomial"(link='logit'))
  names(regression_list_per_thr)[i] <- total_perennial[i]
  summary_list_per_thr[[i]]<-summary(regression_list_per_thr[[i]])
  names(summary_list_per_thr)[i] <- total_perennial[i]
}

pval_per_thr<-c()
for(i in 1:length(total_perennial)){
  pval_per_thr[i]<-summary_list_per_thr[[i]]$coefficients[2,4]
  names(pval_per_thr)[i] <- total_perennial[i]
}

SeedLot <- total_perennial
pval_bio_per1 <- data.frame(SeedLot,P_value_bio1=c(round(pval_per_thr,digits=6)),
                            P_value_bio2='NA')


# Perennial ryegrass - Puccinia -------------------------------------------------------------
perennial_puccinia$Disease.group <- 0
perennial_puccinia$Disease.group[which(perennial_puccinia$Disease=='1' | perennial_puccinia$Disease=='2')] <- 1

perennial_puccinia$Disease <-as.factor(perennial_puccinia$Disease)
perennial_puccinia$MRTrt <-as.factor(perennial_puccinia$MRTrt)
total_perennial <- unique(perennial_puccinia$SeedLot)

regression_list_per_puc <- list() #store ordinal regressions
summary_list_per_puc <- list() #store full summaries
for(i in 1:length(total_perennial)){
  regression_list_per_puc[[i]] <- glm(Disease ~ MRTrt, 
                                      data = perennial_puccinia[perennial_puccinia$SeedLot==total_perennial[[i]],], 
                                      family = "binomial"(link='logit'))
  names(regression_list_per_puc)[i] <- total_perennial[i]
  summary_list_per_puc[[i]]<-summary(regression_list_per_puc[[i]])
  names(summary_list_per_puc)[i] <- total_perennial[i]
}

pval_per_puc<-c()
for(i in 1:length(total_perennial)){
  pval_per_puc[i]<-summary_list_per_puc[[i]]$coefficients[2,4]
  names(pval_per_puc)[i] <- total_perennial[i]
}

SeedLot <- total_perennial
pval_bio_per2 <-  data.frame(SeedLot,P_value_bio1=c(round(pval_per_puc,digits=6)),
                             P_value_bio2='NA')


# # combine bioassays make full_summary_bio1 table -------------------------------------------------------------
full_summary_bio1 <-rbind(pval_bio_bee, pval_bio_oni1, pval_bio_oni2, pval_bio_spi1, pval_bio_spi2, 
                         pval_bio_cor, pval_bio_pep, pval_bio_pep2, pval_bio_per1, pval_bio_per2, pval_bio_fes)


